<?php
// Include the database connection
include('../connection.php');

$base_url = 'https://backend.v99.in/files/';

// Generate an array of image URLs
$image_links = [];
for ($i = 1; $i <= 10; $i++) {
    $image_links[] = $base_url . "img$i.jpg";
}

// Fetch all client IDs
$sql = "SELECT id FROM clients";
$result = $conn->query($sql);

if ($result->num_rows > 0) {
    // Loop through each client and update with a random image link
    while ($row = $result->fetch_assoc()) {
        $random_image = $image_links[array_rand($image_links)]; // Select a random image
        $client_id = $row['id'];

        // Prepare the update statement
        $update_sql = "UPDATE clients SET logo = ? WHERE id = ?";
        $stmt = $conn->prepare($update_sql);
        $stmt->bind_param("si", $random_image, $client_id);

        // Execute the update
        $stmt->execute();
    }
}

// Close the database connection
$conn->close();
?>
