<?php
// Include the database connection
include('../connection.php');

$codes = [
    '500005',
    '500004',
    '600001',
    '600002',
    '600003',
    '600004',
    '500006'
];

// Fetch all client IDs
$sql = "SELECT id FROM clients";
$result = $conn->query($sql);

if ($result->num_rows > 0) {
    // Loop through each client and update with a random pincode
    while ($row = $result->fetch_assoc()) {
        $random_link = $codes[array_rand($codes)]; // Select a random link
        $client_id = $row['id'];

        // Prepare the update statement
        $update_sql = "UPDATE clients SET pincode = ? WHERE id = ?";
        $stmt = $conn->prepare($update_sql);
        $stmt->bind_param("si", $random_link, $client_id);

        // Execute the update
        $stmt->execute();
    }
}

// Close the database connection
$conn->close();
?>
