<?php
// Include the database connection
include('../connection.php');

// Generate an array of image names
$image_names = [];
for ($i = 1; $i <= 10; $i++) {
    $image_names[] = "img$i.jpg";
}

// Fetch all client IDs
$sql = "SELECT id FROM clients";
$result = $conn->query($sql);

if ($result->num_rows > 0) {
    // Loop through each client and update with random images
    while ($row = $result->fetch_assoc()) {
        $num_images = rand(4, 8); // Random number of images between 4 and 8
        $random_images = array_rand($image_names, $num_images); // Randomly pick images
        
        // Ensure $random_images is an array
        if (!is_array($random_images)) {
            $random_images = [$random_images];
        }

        // Map random indices to image names
        $selected_images = array_map(function ($index) use ($image_names) {
            return $image_names[$index];
        }, $random_images);

        // Create a comma-separated string of image names
        $images_string = implode(',', $selected_images);
        $client_id = $row['id'];

        // Prepare the update statement
        $update_sql = "UPDATE clients SET images = ? WHERE id = ?";
        $stmt = $conn->prepare($update_sql);
        $stmt->bind_param("si", $images_string, $client_id);

        // Execute the update
        $stmt->execute();
    }
}

// Close the database connection
$conn->close();
?>
