<?php
// Include the database connection
include('connection.php');

$youtube_links = [
    'https://www.youtube.com/embed/I738UjAGa5g',
    'https://www.youtube.com/embed/6FYj8tP--6U',
    'https://www.youtube.com/embed/PgKzHZOXxLs',
    'https://www.youtube.com/embed/WCeDBW-3YlE',
    'https://www.youtube.com/embed/yOBntbif-_o',
    'https://www.youtube.com/embed/vhNGVjt_Bsk'
];

// Fetch all client IDs
$sql = "SELECT id FROM clients";
$result = $conn->query($sql);

if ($result->num_rows > 0) {
    // Loop through each client and update with a random YouTube link
    while ($row = $result->fetch_assoc()) {
        $random_link = $youtube_links[array_rand($youtube_links)]; // Select a random link
        $client_id = $row['id'];

        // Prepare the update statement
        $update_sql = "UPDATE clients SET yt_video = ? WHERE id = ?";
        $stmt = $conn->prepare($update_sql);
        $stmt->bind_param("si", $random_link, $client_id);

        // Execute the update
        $stmt->execute();
    }
}

// Close the database connection
$conn->close();
?>
