<?php
// Include the database connection
include('connection.php');

// Get the search term from the query parameter
$searchTerm = isset($_GET['search']) ? $_GET['search'] : '';

// If no search term is provided, return an error message
if (empty($searchTerm)) {
    header('Content-Type: application/json');
    echo json_encode([
        'status' => 'error',
        'message' => 'Search term is required'
    ]);
    exit;
}


// Prepare SQL query components
$sql = "SELECT id, company_name, description, address, whatsapp, logo, city, state 
        FROM clients 
        WHERE deleted_at IS NULL 
        AND (city LIKE ? 
        OR state LIKE ? 
        OR address LIKE ? 
        OR company_name LIKE ? 
        OR contact_person LIKE ? 
        OR mobile_number LIKE ? 
        OR whatsapp LIKE ? 
        OR email LIKE ?";

// Determine if search term is numeric
if (is_numeric($searchTerm)) {
    $sql .= " OR id = ? OR pincode = ?";
}

$sql .= ")";

// Prepare the statement
$stmt = $conn->prepare($sql);

// Add wildcards for partial matching
$searchTermWithWildcard = '%' . $searchTerm . '%';

// Bind parameters based on whether it's numeric or not
if (is_numeric($searchTerm)) {
    // Bind for city, state, address, company_name, contact_person, mobile_number, whatsapp, email + id and pincode
    $stmt->bind_param("sssssssss", 
        $searchTermWithWildcard, // city
        $searchTermWithWildcard, // state
        $searchTermWithWildcard, // address
        $searchTermWithWildcard, // company_name
        $searchTermWithWildcard, // contact_person
        $searchTermWithWildcard, // mobile_number
        $searchTermWithWildcard, // whatsapp
        $searchTermWithWildcard, // email
        $searchTerm,             // id
        $searchTerm              // pincode
    );
} else {
    // Bind only for city, state, address, company_name, contact_person, mobile_number, whatsapp, email
    $stmt->bind_param("ssssssss", 
        $searchTermWithWildcard, // city
        $searchTermWithWildcard, // state
        $searchTermWithWildcard, // address
        $searchTermWithWildcard, // company_name
        $searchTermWithWildcard, // contact_person
        $searchTermWithWildcard, // mobile_number
        $searchTermWithWildcard, // whatsapp
        $searchTermWithWildcard  // email
    );
}

// Execute the query
$stmt->execute();

// Get the result
$result = $stmt->get_result();
$data = [];

// Fetch data and store it in an array
while ($row = $result->fetch_assoc()) {
    $data[] = $row;
}

// Check if data exists and send response
header('Content-Type: application/json');
if (count($data) > 0) {
    echo json_encode([
        'status' => 'success',
        'data' => $data
    ]);
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'No clients found'
    ]);
}

// Close the statement and connection
$stmt->close();
$conn->close();
?>
