<?php
header("Content-Type: application/json");

// Include your database connection file
include('connection.php');

// Prepare the SQL query to count clients where deleted_at is NULL
$sql = "SELECT COUNT(*) AS client_count FROM clients WHERE deleted_at IS NULL";

// Execute the query
$result = $conn->query($sql);

// Check if the query was successful
if ($result) {
    // Fetch the result as an associative array
    $row = $result->fetch_assoc();
    
    // Return the count in JSON format
    echo json_encode([
        'status' => 'success',
        'count' => $row['client_count']
    ]);
} else {
    // Return an error message if the query fails
    echo json_encode([
        'status' => 'error',
        'message' => 'Failed to retrieve client count: ' . $conn->error
    ]);
}

// Close the database connection
$conn->close();
?>
