<?php
header("Content-Type: application/json");

include('connection.php');

// Query to get all IDs where deleted_at is NULL
$sql = "SELECT id FROM clients WHERE deleted_at IS NULL ORDER BY id ASC";

// Execute the query
$result = $conn->query($sql);

if ($result) {
    $ids = array();
    
    // Fetch all IDs into an array as strings
    while ($row = $result->fetch_assoc()) {
        $ids[] = (string)$row['id'];  // Cast to string instead of int
    }
    
    echo json_encode([
        'status' => 'success',
        'count' => count($ids),
        'ids' => $ids
    ]);
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'Failed to fetch IDs: ' . $conn->error
    ]);
}

// Close the database connection
$conn->close();
?>