<?php
// Include the database connection
include('connection.php');

// Get the current page number and set the limit
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$limit = 15; // Number of rows per page
$offset = ($page - 1) * $limit;

// Prepare the SQL query
$sql = "SELECT id, company_name, description, address, whatsapp, mobile_number, email, logo, city, state, pincode  
        FROM clients 
        WHERE deleted_at IS NULL 
        ORDER BY id DESC  
        LIMIT ?, ?";

$stmt = $conn->prepare($sql);
$stmt->bind_param("ii", $offset, $limit);

// Execute the query
$stmt->execute();

// Get the result
$result = $stmt->get_result();
$data = [];

// Fetch data and store it in an array
while ($row = $result->fetch_assoc()) {
    $data[] = $row;
}

// Get the total number of records for pagination
$total_sql = "SELECT COUNT(*) as total FROM clients WHERE deleted_at IS NULL";
$total_result = $conn->query($total_sql);
$total_row = $total_result->fetch_assoc();
$total_records = $total_row['total'];

// Calculate total pages
$total_pages = ceil($total_records / $limit);

// Prepare the response data
$response = [
    'data' => $data,
    'current_page' => $page,
    'total_pages' => $total_pages,
    'total_records' => $total_records
];

// Set response header to JSON
header('Content-Type: application/json');
echo json_encode($response);

// Close the database connection
$conn->close();
?>
