<?php
// Set the response header to JSON
header('Content-Type: application/json');

// Define the target directory
$targetDir = '../files/'; // Adjust this path based on your directory structure

// Check if the directory exists; if not, create it
if (!is_dir($targetDir)) {
    if (!mkdir($targetDir, 0755, true)) {
        echo json_encode(['status' => 'error', 'message' => 'Failed to create target directory.']);
        exit;
    }
}

// Check if files were uploaded
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['file'])) {
    $uploadedFiles = $_FILES['file']; // This will be an array of files
    $responses = []; // Array to store responses for each file

    // Loop through each uploaded file
    foreach ($uploadedFiles['name'] as $key => $name) {
        if ($uploadedFiles['error'][$key] === UPLOAD_ERR_OK) {
            // Get file details
            $originalFileName = pathinfo($name, PATHINFO_FILENAME); // Original filename without extension
            $extension = pathinfo($name, PATHINFO_EXTENSION); // File extension

            // Create a timestamped filename
            $timestamp = date("Ymd_His"); // Format: YYYYMMDD_HHMMSS
            $newFileName = $originalFileName . '_' . $timestamp . '.' . $extension; // Append timestamp to filename

            // Define the full path for the new file
            $targetFilePath = $targetDir . $newFileName;

            // Move the uploaded file to the target directory
            if (move_uploaded_file($uploadedFiles['tmp_name'][$key], $targetFilePath)) {
                $responses[] = [
                    'status' => 'success',
                    'file_name' => $newFileName,
                    'file_path' => $targetFilePath,
                ];
            } else {
                $responses[] = [
                    'status' => 'error',
                    'message' => 'Failed to move uploaded file: ' . $name,
                ];
            }
        } else {
            // Handle specific error codes
            switch ($uploadedFiles['error'][$key]) {
                case UPLOAD_ERR_INI_SIZE:
                case UPLOAD_ERR_FORM_SIZE:
                    $responses[] = [
                        'status' => 'error',
                        'message' => 'File is too large: ' . $name,
                    ];
                    break;
                case UPLOAD_ERR_PARTIAL:
                    $responses[] = [
                        'status' => 'error',
                        'message' => 'File was only partially uploaded: ' . $name,
                    ];
                    break;
                case UPLOAD_ERR_NO_FILE:
                    $responses[] = [
                        'status' => 'error',
                        'message' => 'No file was uploaded: ' . $name,
                    ];
                    break;
                default:
                    $responses[] = [
                        'status' => 'error',
                        'message' => 'Unknown upload error for: ' . $name . ' - Error code: ' . $uploadedFiles['error'][$key],
                    ];
                    break;
            }
        }
    }

    // Return responses for all uploaded files
    echo json_encode($responses);
} else {
    echo json_encode(['status' => 'error', 'message' => 'No files were uploaded.']);
}
?>
