<?php
// Include the database connection
include('connection.php');

// Get the client id from the URL parameter
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if ($id > 0) {
    // Prepare the SQL query to fetch a single client by ID
    $sql = "SELECT * FROM clients WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $id);

    // Execute the query
    $stmt->execute();

    // Get the result
    $result = $stmt->get_result();
    
    // Check if the client exists
    if ($result->num_rows > 0) {
        // Fetch the data for the client
        $client = $result->fetch_assoc();

        // Convert comma-separated images and video into arrays
        if (!empty($client['images'])) {
            $client['images'] = explode(',', $client['images']);
        } else {
            $client['images'] = []; // Return an empty array if no images are found
        }

        // Return the data in JSON format
        header('Content-Type: application/json');
        echo json_encode([
            'status' => 'success',
            'data' => $client
        ]);
    } else {
        // If no client found, return an error message
        header('Content-Type: application/json');
        echo json_encode([
            'status' => 'error',
            'message' => 'Client not found'
        ]);
    }

    // Close the statement
    $stmt->close();
} else {
    // If the ID is invalid, return an error message
    header('Content-Type: application/json');
    echo json_encode([
        'status' => 'error',
        'message' => 'Invalid client ID'
    ]);
}

// Close the database connection
$conn->close();
?>
