<?php
// Include the database connection
include('connection.php');

// Get the client id from the URL parameter
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if ($id > 0) {
    // Prepare the SQL query to soft delete a client by ID
    $sql = "UPDATE clients SET deleted_at = NOW() WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $id);

    // Execute the query
    if ($stmt->execute()) {
        // Check if any rows were affected
        if ($stmt->affected_rows > 0) {
            // Return success response
            header('Content-Type: application/json');
            echo json_encode([
                'status' => 'success',
                'message' => 'Client successfully soft deleted'
            ]);
        } else {
            // If no rows were affected, client may not exist or already marked as deleted
            header('Content-Type: application/json');
            echo json_encode([
                'status' => 'error',
                'message' => 'Client not found or already deleted'
            ]);
        }
    } else {
        // If query execution fails, return an error message
        header('Content-Type: application/json');
        echo json_encode([
            'status' => 'error',
            'message' => 'Failed to execute query'
        ]);
    }

    // Close the statement
    $stmt->close();
} else {
    // If the ID is invalid, return an error message
    header('Content-Type: application/json');
    echo json_encode([
        'status' => 'error',
        'message' => 'Invalid client ID'
    ]);
}

// Close the database connection
$conn->close();
?>
