<?php
header("Content-Type: application/json");

include('../connection.php');

// Get the JSON input from the request body
$data = json_decode(file_get_contents("php://input"), true);

// Check if ID is provided
if (!isset($data['id'])) {
    echo json_encode([
        'status' => 'error',
        'message' => 'Client ID is required'
    ]);
    exit;
}

$id = intval($data['id']);

// Start building the SQL query
$updateFields = [];
$base_url = 'https://backend.mortuarybox.com/files/';

// List of all possible fields
$fields = [
    'company_name', 'description', 'full_description', 'address', 
    'city', 'state', 'pincode', 'email', 'contact_person', 
    'mobile_number', 'whatsapp', 'gmap', 'yt_video', 'youtube', 
    'instagram', 'twitter', 'facebook', 'logo', 'images'
];


foreach ($fields as $field) {
    if (isset($data[$field])) {
        
        $value = $data[$field];

        // Handle integer fields
        if ($field === 'pincode') {
            $updateFields[] = "$field = " . intval($value);
        } else {
            // Escape and quote string values
            $value = $conn->real_escape_string($value);
            $updateFields[] = "$field = '$value'";
        }
    }
}

// If no fields to update were provided
if (empty($updateFields)) {
    echo json_encode([
        'status' => 'error',
        'message' => 'No fields provided for update'
    ]);
    exit;
}

// Construct the final SQL query
$sql = "UPDATE clients SET " . implode(', ', $updateFields) . " WHERE id = $id";

// Execute the query
if ($conn->query($sql)) {
    // Check if any rows were actually updated
    if ($conn->affected_rows > 0) {
        echo json_encode([
            'status' => 'success',
            'message' => 'Client updated successfully'
        ]);
    } else {
        echo json_encode([
            'status' => 'error',
            'message' => 'No client found with the provided ID'
        ]);
    }
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'Failed to update client: ' . $conn->error
    ]);
}

// Close the database connection
$conn->close();
?>