<?php
// Include the database connection
include('../connection.php');

// Start the session
session_start();

// Get the username and password from POST request
$username = isset($_POST['username']) ? $_POST['username'] : '';
$password = isset($_POST['password']) ? $_POST['password'] : '';

// Check if both fields are filled
if (empty($username) || empty($password)) {
    header('Content-Type: application/json');
    echo json_encode([
        'status' => 'error',
        'message' => 'Username and password are required.'
    ]);
    exit;
}

// Prepare the SQL query to check for the user
$sql = "SELECT id, name, username, role, blocked FROM admins WHERE username = ? AND password = ?";
$stmt = $conn->prepare($sql);

// Bind parameters
$stmt->bind_param("ss", $username, $password);

// Execute the query
$stmt->execute();

// Get the result
$result = $stmt->get_result();

// Check if a user was found
if ($result->num_rows > 0) {
    $user = $result->fetch_assoc();

    // Check if the user is blocked (assuming 1 is blocked and 0 is not blocked)
    if ($user['blocked'] == 1) {
        header('Content-Type: application/json');
        echo json_encode([
            'status' => 'error',
            'message' => 'Your account is blocked.'
        ]);
        exit;
    }

    // Store user information in session (optional)
    $_SESSION['username'] = $username;
    $_SESSION['role'] = $user['role'];

    // Return success response
    header('Content-Type: application/json');
    echo json_encode([
        'status' => 'success',
        'message' => 'Login successful.',
        'user' => [
            'id' => $user['id'],
            'name' => $user['name'],
            'username' => $user['username'],
            'role' => $user['role']
        ]
    ]);
} else {
    // If no user found, return an error message
    header('Content-Type: application/json');
    echo json_encode([
        'status' => 'error',
        'message' => 'Invalid username or password.'
    ]);
}

// Close the statement and connection
$stmt->close();
$conn->close();
?>
