<?php
header("Content-Type: application/json");

include('../connection.php');

// Query to get the maximum ID
$sql = "SELECT MAX(id) as max_id FROM clients";

// Execute the query
$result = $conn->query($sql);

if ($result) {
    $row = $result->fetch_assoc();
    $maxId = $row['max_id'];
    
    // Handle case where table might be empty
    if ($maxId === null) {
        $maxId = 0;
    }
    
    echo json_encode([
        'status' => 'success',
        'max_id' => (int)$maxId
    ]);
} else {
    echo json_encode([
        'status' => 'error',
        'message' => 'Failed to fetch max ID: ' . $conn->error
    ]);
}

// Close the database connection
$conn->close();
?>