<?php
// Include the database connection
include('../connection.php');

// Get the limit from the query parameters, default to 300 if not provided
$limit = isset($_GET['limit']) ? (int)$_GET['limit'] : 300;

// Prepare the SQL query
$sql = "SELECT * FROM clients  WHERE deleted_at IS NULL ORDER BY id DESC  LIMIT ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $limit);

// Execute the query
$stmt->execute();

// Get the result
$result = $stmt->get_result();
$data = [];

// Fetch data and store it in an array
while ($row = $result->fetch_assoc()) {
    $data[] = $row;
}

// Prepare the response data
$response = [
    'data' => $data,
    'total_records' => count($data) // Total records returned in this request
];

// Set response header to JSON
header('Content-Type: application/json');
echo json_encode($response);

// Close the database connection
$conn->close();
?>
