<?php
header("Content-Type: application/json");

include('../connection.php');

$base_url = 'https://backend.mortuarybox.com/files/';
// Default values for optional fields
$defaultValues = [
    'logo' => "https://backend.mortuarybox.com/files/img1.jpeg",
//    'images' => "defaultimage2.jpeg,defaultimage6.jpeg,defaultimage7.jpeg,defaultimage5.jpeg,defaultimage8.png,defaultimage1.jpeg,defaultimage3.jpeg,defaultimage4.jpeg",
    'images' => "img1.jpeg,img2.png,img3.jpeg,img4.jpeg,img5.jpeg,img6.jpeg,img7.jpeg,img8.jpeg",

    'yt_video' => "https://www.youtube.com/embed/WCeDBW-3YlE",
    'gmap' => "https://maps.google.com/maps?q=17.7291367,79.1188458&t=&z=15&ie=UTF8&iwloc=&output=embed",
    
    'youtube' => "https://www.youtube.com/@a1kitchenhyderabad", // Default YouTube link
    'instagram' => "https://www.instagram.com/ayaankitchen?igsh=MXFneXBpd2twdTM4eA==", // Default Instagram link
    'twitter' => "https://twitter.com/share?url=https://www.ayaankitchen.in/", // Default Twitter link
    'facebook' => "https://www.facebook.com/sharer.php?u=https://www.ayaankitchen.in/" // Default Facebook link
];

// Get the JSON input from the request body
$data = json_decode(file_get_contents("php://input"), true);

// Validate required fields
if (isset($data['company_name'], $data['description'], $data['full_description'], $data['address'], $data['city'], $data['state'], $data['pincode'], $data['mobile_number'], $data['whatsapp'])) {
    // Assign default values if optional fields are not set
    $email = !empty($data['email']) ? $data['email'] : '';
    $gmap = !empty($data['gmap']) ? $data['gmap'] : $defaultValues['gmap'];
    $yt_video = !empty($data['yt_video']) ? $data['yt_video'] : $defaultValues['yt_video'];
    
    // Check if logo is provided and append base URL if necessary
    if (!empty($data['logo'])) {
        $logo = $base_url . $data['logo']; // Append base URL to logo filename
    } else {
        $logo = $defaultValues['logo']; // Use default logo if not provided
    }
    
    $images = !empty($data['images']) ? $data['images'] : $defaultValues['images'];

    // Sanitize inputs to avoid SQL injection
    //$id = $conn->real_escape_string($data['id']);
    $company_name = $conn->real_escape_string($data['company_name']);
    $description = $conn->real_escape_string($data['description']);
    $full_description = $conn->real_escape_string($data['full_description']);
    $address = $conn->real_escape_string($data['address']);
    $city = $conn->real_escape_string($data['city']);
    $state = $conn->real_escape_string($data['state']);
    $contact_person = $conn->real_escape_string($data['contact_person']);
    $pincode = intval($data['pincode']);
    $mobile_number = $conn->real_escape_string($data['mobile_number']);
    $whatsapp = $conn->real_escape_string($data['whatsapp']);
    $yt_video = $conn->real_escape_string($yt_video);
    $logo = $conn->real_escape_string($logo);
    $images = $conn->real_escape_string($images);
    
    // New social media links with defaults
    $youtube = !empty($data['youtube']) ? $data['youtube'] : $defaultValues['youtube'];
    $instagram = !empty($data['instagram']) ? $data['instagram'] : $defaultValues['instagram'];
    $twitter = !empty($data['twitter']) ? $data['twitter'] : $defaultValues['twitter'];
    $facebook = !empty($data['facebook']) ? $data['facebook'] : $defaultValues['facebook'];

    $gmap = $conn->real_escape_string($gmap); 

    $sql = "INSERT INTO clients (company_name, description, full_description, address, city, state, pincode, email, contact_person, mobile_number, whatsapp, gmap, yt_video, youtube, instagram, twitter, facebook, logo, images) 
            VALUES ('$company_name', '$description', '$full_description', '$address', '$city', '$state', 
            $pincode, '$email', '$contact_person', '$mobile_number', '$whatsapp', '$gmap', 
            '$yt_video', '$youtube', '$instagram', '$twitter', '$facebook', '$logo', '$images')";


    // Execute the query
    if ($conn->query($sql)) {
        // Return success response
        echo json_encode([
            'status' => 'success',
            'message' => 'Client added successfully',
            'client_id' => $conn->insert_id // Return the ID of the newly created client
        ]);
    } else {
        // Return error response
        echo json_encode([
            'status' => 'error',
            'message' => 'Failed to add client: ' . $conn->error
        ]);
    }
} else {
    // If required fields are missing, return an error message
    echo json_encode([
        'status' => 'error',
        'message' => 'Missing required fields'
    ]);
}

// Close the database connection
$conn->close();
?>
